<?php
// -- Include the required data and requirements for this page
include("templates/headers/inc.php");

// Include the JS file
$js_files = array("js/pages/create-quiz.js");

// Metadata informations of this page
$page_title = "Create a Quiz";
$page_slug	= "create-quiz";

// Get website config
$site_config = $dbh->prepare("SELECT * FROM config WHERE config_name IN ('website_name','website_tagline','ads_code')");
$site_config->execute();

$config_array = array();

while($config = $site_config->fetch(PDO::FETCH_ASSOC)) {
	$config_array[$config["config_name"]] = $config["config_value"];
}

$website_name = $config_array["website_name"];
$website_tagline = $config_array["website_tagline"];
$ads_code = $config_array["ads_code"];

// -- General checks and redirects
// If we have a session, redirect !
if(!$_SESSION || !isset($_SESSION["USER_ID"])) {
	header("Location: index.php?action=need_log_in");
	exit;
}

$user_id = $_SESSION["USER_ID"];

// Check if user exists...
$quiz_sql = $dbh->prepare("	SELECT *
							FROM quiz
							WHERE user_id = :user_id
							");
					
$quiz_sql->bindParam(':user_id', $user_id);
$quiz_sql->execute();

$ex_questions = array(
	"Am I wearing socks right now?",
	"Am I awesome ?",
	"Am I sassy?",
	"Do I wear long or short socks usually?",
	"Which did I not get for Christmas last year?",
	"Which of the following have I never eaten?",
	"How much wood could a wood-chuck chuck?",
	"What is my favorite color?",
	"What is my favorite sport?",
	"What is my favorite food?",
	"What is my favorite animal?",
	"What is my favorite team?",
	"What is my favorite number?",
	"What is my favorite subject in school?",
	"What is my favorite band?",
	"What is my birthday?",
	"How old am I?",
	"Am I left or right handed?",
	"Am I a morning person? ",
	"What is my eye color?",
	"Do I have my own room?",
	"Do I like sports?",
	"Do I like to read?",
	"Do I like to swim?",
	"Do I like to draw?",
	"Do I exercise?",
	"When is the last time I cried?",
	"What is my hair color?",
	"How tall am I?"
);

	
// -- Include the header template
include("templates/headers/global_header.php")
?>

<?php
if($ads_code != "") {
?>
<div class="row">
	<div class="col-md-12">
		<?php
		echo $ads_code;
		?>
	</div>
</div>
<?php
}	
?>

<div class="row">
	
	<div class="inner-container content" id="main-content">
					
		<h3>Quiz Creation</h3>
		
		<div class="content-inner">
			
			<div class="alert alert-info alert-center alert-create">
				Take a few minutes to create your quiz, share it with your friends, and discover who really knows you <i class="em em-stuck_out_tongue"></i>
			</div>
			
			<form action="" method="post">
				<div class="qcreator-part-1">
					<div class="form-group form-centered">
						<label>Title</label>
						<input type="text" autocomplete="off" class="form-control title" name="title" placeholder="Give a title to your quiz" />
						<br />
						<a class="btn btn-primary btn-next-qcreator" href="create-quiz.php">Next <i class="fas fa-caret-right"></i></a>
					</div>	
				</div>
				<div class="qcreator-part-2">
					<div class="question-block current" data-number="1">
						<div class="form-group form-centered">
							<label>Question #1</label>
							<input type="text" autocomplete="off" class="form-control q-title-1" name="q-title-1" placeholder="Write a question for your friends..." />
							<small class="form-text text-muted rand-question">Example : <span></span></small>
						</div>
						<table class="table table-answers">
							<tr>
								<th>Answers<br><small>Write the list of answers your friends will see</small></th>
								<th>Correct?<br><small>Check one or more correct answers</small></th>
							</tr>
							<tr class="q-answer">
								<td>
									<input type="text" autocomplete="off" class="form-control q-title-1-a-title-1" name="q-title-1-a-title-1" placeholder="Write answer 1" />
									<div align="left">
										<small class="form-text text-muted text-form"><i class="fas fa-info-circle"></i> This answer must be set</small>
									</div>
								</td>
								<td>
									<label class="switch">
										<input checked="checked" class="q-title-1-a-good-1" name="a-good-1" type="checkbox">
										<span class="slider round"></span>
									</label>
								</td>
							</tr>
							<tr class="q-answer">
								<td>
									<input type="text" autocomplete="off" class="form-control q-title-1-a-title-2" name="q-title-1-a-title-2" placeholder="Write answer 2" />
									<div align="left">
										<small class="form-text text-muted text-form"><i class="fas fa-info-circle"></i> This answer must be set</small>
									</div>
								</td>
								<td>
									<label class="switch">
										<input class="a-good-2" name="q-title-1-a-good-2" type="checkbox">
										<span class="slider round"></span>
									</label>
								</td>
							</tr>
							<tr class="q-answer">
								<td>
									<input type="text" autocomplete="off" class="form-control q-title-1-a-title-3" name="q-title-1-a-title-3" placeholder="Write answer 3" />
									<div align="left">
										<small class="form-text text-muted text-form"><i class="fas fa-info-circle"></i> This answer is optional</small>
									</div>
								</td>
								<td>
									<label class="switch">
										<input class="a-good-3" name="q-title-1-a-good-3" type="checkbox">
										<span class="slider round"></span>
									</label>
								</td>
							</tr>
							<tr class="q-answer">
								<td>
									<input type="text" autocomplete="off" class="form-control q-title-1-a-title-4" name="q-title-1-a-title-4" placeholder="Write answer 4" />
									<div align="left">
										<small class="form-text text-muted text-form"><i class="fas fa-info-circle"></i> This answer is optional</small>
									</div>
								</td>
								<td>
									<label class="switch">
										<input class="a-good-4" name="q-title-1-a-good-4" type="checkbox">
										<span class="slider round"></span>
									</label>
								</td>
							</tr>
						</table>
						<div class="block-add-question">
							<a class="btn btn-sm btn-primary btn-add-another-question" href="#">Add Question <i class="fas fa-angle-right"></i></a>
						</div>
					</div>
					<div class="alert alert-success alert-center quiz-questions-alert">You currently have <b>0</b> question(s) in your quiz.</div>
					<center>
						<a class="btn btn-success btn-save-quiz" href="#"><i class="fas fa-check"></i> Save Quiz</a>
					</center>
				</div>
				<div class="qcreator-part-3">
					
					<div class="emo-container">
						<i class="em em-zany_face"></i>
					</div>
					<div class="txt-container">
						<h4><b>Congrats!</b> Your Quiz is Ready to be Shared with your Friends!</h4>
						<hr />
						<div class="input-group">
							<input type="text" id="quiz-link" class="form-control" readonly value="" />
							<div class="input-group-append">
								<button class="btn btn-primary btn-copy" data-clipboard-target="#quiz-link" type="button" id="button-addon2">Copy</button>
								</div>
						</div>
						<small><i class="fas fa-info-circle"></i> Copy this link and share it with your friends so they can do it!</small>
						<hr />
						<h4>Share it Now with your Friends :</h4>
						<div id="share"></div>
						<hr />
						<a href="home.php" class="btn btn-primary"><i class="fas fa-home"></i> Home</a>
					</div>
					
				</div>
			</form>
		
		</div>
		
	</div>
					
</div>


<script type="text/javascript">
	var url = "<?php echo URL; ?>";
</script>

<?php
// -- Include the footer template
include("templates/footers/global_footer.php");	
?>
			